/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xlasterr.c 
 *       Test/debug function to display the last error as a message
 * -----------------------------------------------------------------*/

#include <xlasterr.h>
#include <xutil.h>

#define NUM_BUF_LEN     11

#define NON_WIN_ERR     "Non-Windows Error Message Received"
#define MSG_TITLE       "Last Win API Error"
#define ERR_FILE_NAME   "File: "
#define ERR_LINE_NUM    "\nLine: "
#define ERR_NUMBER      "\nErr. Num: "

#define LENGTH_OF_ALL_OTHER_JUNK   (sizeof(ERR_FILE_NAME) + \
                                    sizeof(ERR_LINE_NUM) + \
                                    sizeof(ERR_NUMBER) + \
                        sizeof(HELLO_BEST) + NUM_BUF_LEN + sizeof('\0'))


#ifdef DOSW32
typedef void *PVOID;              /* winnt.h */
typedef unsigned long ULONG; /* xaddrmap.h */
typedef long LONG;                /* winnt.h */
typedef unsigned char  BOOLEAN;            /* winnt.h */
void EXPORT DisplayLastError( PVOID pFileName,
                             ULONG uLineNumber,
                             LONG lErrNum,
                             BOOLEAN fOutputToVC
                             ) {;}
#else


/*
//////////////////////////////////////////////////////////////////////////////
*/
void EXPORT DisplayLastError( PVOID pFileName,
                             ULONG uLineNumber,
                             LONG lErrNum,
                             BOOLEAN fOutputToVC
                             )
{
  
  LPVOID    lpMsgBuf = NULL;
  char * pcMsgBuff = NULL;
  DWORD    dwErrNo;
  size_t   dwMsgLen = 0;
  char   cNumBuff[NUM_BUF_LEN] = "";    /* For the line number */
  DWORD   dwNumSysChars;
  int fWeMallocd = 0;
  
  /* use user's error number if passed in */
  dwErrNo = (DWORD)(lErrNum ? lErrNum: GetLastError());
  
  /* just a quick check to see if there really is an error */
  if( ERROR_SUCCESS == dwErrNo )
  {
    return;
  }
  
  dwNumSysChars = FormatMessage( 
    FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
    NULL,
    dwErrNo,
    MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),  /* Default language */
    (LPTSTR) &lpMsgBuf,
    0,
    NULL 
    );
  
  if ( !lpMsgBuf )
  {
    lpMsgBuf = BestXMemMalloc(sizeof(NON_WIN_ERR) + 1);
    if( NULL == lpMsgBuf )
      return;
    BESTX_STRCPY(lpMsgBuf, NON_WIN_ERR);
    fWeMallocd = 1;
    dwNumSysChars = sizeof(NON_WIN_ERR) + 1;
  }
  
  if( pFileName )
  {
    dwMsgLen = (dwNumSysChars + BESTX_STRLEN((char *)pFileName) + LENGTH_OF_ALL_OTHER_JUNK);
    pcMsgBuff = BestXMemMalloc(dwMsgLen);
    
    if( NULL == pcMsgBuff )    /* whoops ! */
    {
      return;
    }
    
    /* Attach filename and line number etc to system-allocated string */
    BESTX_SPRINTF(pcMsgBuff, "\n\n%s", lpMsgBuf);
    
    BESTX_SPRINTF(cNumBuff, "%x", dwErrNo );
    BESTX_STRCAT(pcMsgBuff, ERR_NUMBER );
    BESTX_STRCAT(pcMsgBuff, cNumBuff );

    BESTX_STRCAT(pcMsgBuff, HELLO_BEST );
    BESTX_STRCAT(pcMsgBuff, ERR_FILE_NAME );
    BESTX_STRCAT(pcMsgBuff, (const char *)pFileName );
    
    if( uLineNumber )
    {
      BESTX_SPRINTF( cNumBuff, "%d", uLineNumber );
      BESTX_STRCAT( pcMsgBuff, ERR_LINE_NUM );
      BESTX_STRCAT( pcMsgBuff, cNumBuff );
    }
  }
  else
  {
    pcMsgBuff = (PCHAR)lpMsgBuf;
  }
  
  /* Display the msg.*/
  if( fOutputToVC )
  {
    OutputDebugString(pcMsgBuff);
  }
  else
  {
    MessageBox( NULL, pcMsgBuff, MSG_TITLE, MB_OK|MB_ICONINFORMATION );
  }
  
  /* Free buffers */
  
  if ( pcMsgBuff == lpMsgBuf )  /* only free one of them */
  {
      pcMsgBuff = NULL;
  }

  BestXMemFree(& pcMsgBuff );
  
  if ( fWeMallocd )
  {
    BestXMemFree(& lpMsgBuf );
  }
  else
  {
    LocalFree( lpMsgBuf );
  }
  
  return;
}

#endif /* DOSW32 */
